/*
	() , 2003-2009

	   OWEN_IO.

	----------------------------------------------------------------
	  RS485,  RS232-RS485
	----------------------------------------------------------------
        9600, 8  ,  , 1  ,
	  AC3

     
		8
		1
		138
		8
		101
		202

    ----------------------------------------------------------------
      2(RS232- )
    ----------------------------------------------------------------
     
		51
		38
		384
		32
		33
*/

#include <conio.h>
#include <locale.h>
#include <stdio.h>
#include <windows.h>


#include "../../lib/owen_io.h"


void pressAnyKey()
{
	printf("\n  ...");

	_getch();

	printf("\n");
}

int askUser(const char* message)
{
	printf("%s", message);

	int c = 0;
	scanf("%d", &c);
	fflush(stdin);

	printf("\n");

	return c;
}

//
//     2
//
void printTemp(const char* name, float t)
{
	printf("\t%s: ", name);

	if (t != -300)
	{
		printf("%f\n", t);
	}
	else
	{
		printf(" .\n");
	}
}

//
//     2
//
void printPreset(const char* name, float t)
{
	printf("\t%s: ", name);

	if (t != -300)
	{
		printf("%f\n", t);
	}
	else
	{
		printf(" .\n");
	}
}

void AS2()
{
	printf(
		"\n :\n\t"
		"51\n\t"
		"38\n\t"
		"384\n\t"
		"32\n\t"
		"33\n\t"
	);
	pressAnyKey();

	int port = 0;
	while (port < 1 || port > 256)
	{
		port = askUser("  COM- (1 - 256): ");
	}

	int res = AC2_Open(port - 1);

	if (res != ERR_OK)
	{
		printf("  .\n");

		return;
	}

	int channel = askUser("\n  51.    AC2 (1 - 8): ");

	float t_prod;
	float t_suh;
	float t_vlag;
	float vlag;

	if (1 <= channel && channel <= 8)
	{
		res = AC2_ReadMpr51(channel - 1, spd_9600, t_prod, t_suh, t_vlag, vlag);

		if (ERR_OK == res)
		{
			printTemp(" ", t_prod);
			printTemp(" ", t_suh);
			printTemp(" ", t_vlag);
			printTemp(" ", vlag);
		}
		else
			printf("    51.\n");

		pressAnyKey();
	}

	float d[8];
	float u[8];
	float temper[8];


	channel = askUser("\n  38.    AC2 (1 - 8): ");

	if (1 <= channel && channel <= 8)
	{
		res = AC2_ReadTRM_UKT_38_T_and_U(
				channel - 1,
				temper[0], temper[1], temper[2], temper[3],
				temper[4], temper[5], temper[6], temper[7],
				u[0], u[1], u[2], u[3], u[4], u[5], u[6], u[7]
			);

		if (ERR_OK == res)
		{
			for (int i = 0; i < 8; ++i)
			{
				printf(" [%d]:\n", i + 1);
				printTemp("", temper[i]);
				printPreset("", u[i]);
			}
		}
		else
			printf("   38\n");

		pressAnyKey();
	}

	channel = askUser("\n  384 .    AC2 (1 - 8): ");

	if (1 <= channel && channel <= 8)
	{
		res = AC2_ReadUKT38sh4_trp(
				channel - 1,
				spd_9600,
				temper[0], temper[1], temper[2], temper[3], 
				temper[4], temper[5], temper[6], temper[7],
				u[0], u[1], u[2], u[3], u[4], u[5], u[6], u[7],
				d[0], d[1], d[2], d[3], d[4], d[5], d[6], d[7]
			);

		if (ERR_OK == res)
		{
			for (int i = 0; i < 8; ++i)
			{
				printf(" [%d]:\n", i + 1);
				printTemp("", temper[i]);
				printPreset("", u[i]);
				printPreset("", d[i]);
			}
		}
		else
			printf("   384\n");

		pressAnyKey();
	}


	channel = askUser("\n  32.    AC2 (1 - 8): ");

	if (1 <= channel && channel <= 8)
	{
		DWORD work_mode;

		res = AC2_ReadTRM32(
			channel - 1, 
			temper[0], temper[1], temper[2], temper[3], 
			temper[4], temper[5], temper[6], 
			work_mode
		);

		if (ERR_OK == res)
		{
			printTemp("  ", temper[0]);
			printTemp("  ", temper[1]);
			printTemp("  ", temper[2]);
			printTemp(" ", temper[3]);

			printPreset("   ", temper[4]);
			printPreset("   ", temper[5]);
			printPreset("  ", temper[6]);

			printf("   %s \n",
				work_mode? "": "");
		}
		else
			printf("   32\n");

		pressAnyKey();
	}


	channel = askUser("\n  33.    AC2 (1 - 8): ");

	if (1 <= channel && channel <= 8)
	{
		res = AC2_ReadTRM33(
				channel - 1,
				temper[0], temper[1], temper[2], temper[3], 
				temper[4], temper[5], temper[6], temper[7],
				u[0], u[1], u[2], u[3]
			);

		if (ERR_OK == res)
		{
			for (int i = 0; i < 8; ++i)
			{
				printf(" [%d]: ", i + 1);
				printTemp("", temper[i]);
			}

			printPreset("  .max  ", u[0]);
			printPreset("  .", u[1]);
			printPreset("    .", u[2]);
			printPreset("    "
				"    ", u[2]);
		}
		else
			printf("   33\n");

		pressAnyKey();
	}

	AC2_Close();
}



//
//     
//

void printError()
{
	char errStr[LASTERRTOSTR_BUFFER_SIZE];

	LastErrToStr(errStr);

	printf("O: %s\n", errStr);
}

void printInt(const char* name, int error, int value)
{
	printf("%s : ", name);

	if (ERR_OK == error)
	{
		printf("%d\n", value);
	}
	else
		printError();
}

void printFloat(const char* name, int error, float value)
{
	printf("%s : ", name);

	if (ERR_OK == error)
	{
		printf("%f\n", value);
	}
	else
		printError();
}


void AS3()
{
	printf(
		":\n\t 9600\n\t"
		"8  \n\t \n\t1  \n\t"
		"  AC3\n\n"
	);

	printf(
		"\n :\n\t"
		"8\n\t"
		"1\n\t"
		"138\n\t"
		"8\n\t"
		"101\n\t"
		"202\n\n"
	);

	pressAnyKey();


	int port = 0;
	while (port < 1 || port > 256)
	{
		port = askUser("  COM- (1 - 256): ");
	}

	int res = OpenPort(port - 1, spd_9600, prty_NONE, databits_8, stopbit_1, RS485CONV_MANUAL);

	if (res != ERR_OK)
	{
		printf("  .\n");

		return;
	}


	printf("\n  101\n\n");

	int address = -1;
	do
		address = askUser("   (0 - 254): ");
	while (address < 0 || address > 254);

	UINT r;
	res = ReadUInt(address, ADRTYPE_8BIT, "in-t", r, -1);
	printInt(" in-t", res, r);

	float value;
	res = ReadFloat24(address, ADRTYPE_8BIT, "AL-d", value, -1);
	printFloat("    AL-d", res, value);

	pressAnyKey();


	printf("\n  LastErrToStr().    Pv  .\n");

	res = ReadFloat24(address, ADRTYPE_8BIT, "Pv", value, 11);
	if (ERR_OK == res)
	{
		printf("   ReadFloat24()   101\n");
	}
	else
	{
		char errStr[LASTERRTOSTR_BUFFER_SIZE];
		LastErrToStr(errStr);

		printf("O: %s\n", errStr);
	}

	pressAnyKey();


	res = ReadFloat24(address, ADRTYPE_8BIT, "Pv", value, -1);
	printFloat(" ", res, value);


	printf("\n  8\n");

	do
		address = askUser("   (0 - 254): ");
	while (address < 0 || address > 254);

	printf("  ...\n");

	int dcnt;
	res = ReadSI8BCD(address, ADRTYPE_8BIT, "DCNT", dcnt);
	printFloat(" DCNT", res, value);

	pressAnyKey();


	printf("  ...\n");
	int hr, m, s, ms;
	res = ReadDTMR(address, ADRTYPE_8BIT, hr, m, s, ms);

	if (ERR_OK == res)
	{
		printf(": %d:%d:%d:%d\n", hr, m, s, ms);
	}
	else
		printError();

	pressAnyKey();


	printf("\n   1\n");

	do
		address = askUser("   (0 - 254): ");
	while (address < 0 || address > 254);

	printf("    50%...\n");

	res = WriteCSET(address, ADRTYPE_8BIT, 500);
	if (ERR_OK == res)
	{
		printf(" .\n");
	}
	else
		printError();

	res = ReadPkpBCD(address, ADRTYPE_8BIT, "DPRC", value);
	printFloat(" DPRC", res, value);

	pressAnyKey();


	printf(" ...\n");

	//     
	char data[OWENIO_DATA_BUFFER_SIZE];

	//    ,   
	//  ,   .
	DWORD dataSize = 0;

	res = OwenIO(address, ADRTYPE_8BIT, 0, "COPN", data, &dataSize);
	if (ERR_OK == res)
	{
		printf(" .\n");
	}
	else
		printError();

	pressAnyKey();


	res = ReadPkpBCD(address, ADRTYPE_8BIT, "DPRC", value);
	printFloat(" DPRC", res, value);

	pressAnyKey();


	printf("\n  138\n");

	do
		address = askUser("   (0 - 254): ");
	while (address < 0 || address > 254);

	int timestamp;
	res = ReadIEEE32(address, ADRTYPE_8BIT, "rEAd", value, timestamp, -1);
	printFloat(" rEAd", res, value);
	printInt(" ", res, timestamp);

	pressAnyKey();


	printf("\n  8\n");

	do
		address = askUser("   (0 - 254): ");
	while (address < 0 || address > 254);

	res = ReadIEEE32(address + 0, ADRTYPE_8BIT, "rEAd", value, timestamp, -1);

	printFloat(" rEAd [ 1]", res, value);
	printInt("  [ 1]", res, timestamp);

	pressAnyKey();


	printf("\n  202\n");

	do
		address = askUser("   (0 - 254): ");
	while (address < 0 || address > 254);

	printf("   \n");

	//
	//    1
	//
	res = ReadFloat24(address + 0, ADRTYPE_8BIT, "Pv", value, -1);
	printFloat(" [ 1]", res, value);

	//
	//    2
	//
	res = ReadFloat24(address + 1, ADRTYPE_8BIT, "Pv", value, -1);
	printFloat(" [ 2]", res, value);

	pressAnyKey();


	printf("    .\n");

	//
	//   (SH)  1
	//
	res = ReadFloat24(address, ADRTYPE_8BIT, "SH", value, 0);
	printFloat("  [ 1]", res, value);

	//
	//   (SH)  1
	//
	printf("      SH [ 1]: ");
	
	value = 2.2f;
	scanf("%f", &value);
	printf("\n");

	res = WriteFloat24(address, ADRTYPE_8BIT, "SH", value, 0);
	printFloat("   [ 1]", res, value);


	//
	//   (SH)  1
	//
	res = ReadFloat24(address, ADRTYPE_8BIT, "SH", value, 0);
	printFloat("  [ 1]", res, value);

	pressAnyKey();


	//
	//    (in.t)  2
	//
	unsigned int type_d;
	res = ReadUInt(address, ADRTYPE_8BIT, "dP", type_d, 1);
	printInt("  [ 2]", res, type_d);

	//
	//    (in.t)  2
	//
	type_d = askUser("   : ");

	res = WriteByte(address, ADRTYPE_8BIT, "dP", type_d, 1);
	printInt("   [ 2]", res, type_d);

	//
	//    (in.t )  2
	//
	res = ReadUInt(address, ADRTYPE_8BIT, "dP", type_d, 1);
	printInt("  [ 2]", res, type_d);

	pressAnyKey();


	printf("\n    .\n");

	//
	//    
	//
	unsigned int type_i;
	res = ReadUInt(address, ADRTYPE_8BIT, "DiSP", type_i, -1);
	printInt("   DiSP", res, type_i);

	 type_i = askUser("   : ");

	res = WriteByte(address, ADRTYPE_8BIT, "DiSP", type_i, -1);
	printInt("    DiSP", res, type_i);

	res = ReadUInt(address, ADRTYPE_8BIT, "DiSP", type_i, -1);
	printInt("   DiSP", res, type_i);

	ClosePort();
}



int main(int /*argc*/, char* /*argv*/[])
{
	char*  locale = setlocale(LC_ALL, "Russian");

	printf("   owen_io.dll c  \n\n");

	if (askUser("\n    AC2? (1-/0-) "))
	{
		AS2();
	}

	if (askUser("\n    AC3? (1-/0-) "))
	{
		AS3();

		pressAnyKey();
	}

	setlocale(LC_ALL, locale);

	return 0;
}
