program dephi_sample;

{$APPTYPE CONSOLE}
(*
         " " 2003-2004()

           OWEN_IO.

                ----------------------------------------------------------------
                  RS485( AC3   RS232-RS485)
                ----------------------------------------------------------------
                       COM1,
                 9600,  , 8  , 1 , AC3

                 
                8     -  32( 8 )
                1    -  24( 8 )
                138  -  8-15( 8 )
                8    -  16-23( 8 )
                101  -  25( 8 )
                202  -  26( 8 )

                ----------------------------------------------------------------
                  2(RS232- )
                ----------------------------------------------------------------
                       COM1

                  (1..8)
                 
                                38/38     -    1
                                33           -    3
                                32           -    4
                                384       -    5
                                5PiC         -    6
                                384       -    7
                                51           -    8
*)

uses
  SysUtils,windows;

const
        COM_1:DWORD=0;
        COM_2:DWORD=1;
        COM_3:DWORD=2;
        COM_4:DWORD=3;
        COM_5:DWORD=4;
        COM_6:DWORD=5;
        COM_7:DWORD=6;
        COM_8:DWORD=7;
//     2
        spd_300:integer=-3;
        spd_600:integer=-2;
        spd_1200:integer=-1;
//     2
        spd_2400:integer=0;
        spd_4800:integer=1;
        spd_9600:integer=2;
        spd_14400:integer=3;
        spd_19200:integer=4;
        spd_28800:integer=5;
        spd_38800:integer=6;
        spd_57600:integer=7;
        spd_115200:integer=8;

//  
// 
        prty_NONE:integer=0;
// 
        prty_EVEN:integer=1;
// 
        prty_ODD:integer=2;

//    
        databits_7:integer=0;
        databits_8:integer=1;

//    
        stopbit_1:integer=0;
        stopbit_1_5:integer=1;
        stopbit_2:integer=2;

//   RS485
//      RTS-  .. AC-3
        RS485CONV_MANUAL:integer=0;
//  
        RS485CONV_AUTO:integer=1;
//      DTR-  .. AC-3
        RS485CONV_MANUAL_DTR:integer=2;

//  
//   
        ERR_OK: integer = 0;
//  
        ERR_INVALID_ARG: integer = -1;
//   	 (  )
        ERR_NO_RESOURCE: integer = -2;
//     
        ERR_NO_MEMORY: integer = -3;
//   
				ERR_RESOURCE_BUSY: integer = -4;
//   
        ERR_INVALID_RESOURCE: integer = -5;
//   
				ERR_UNSUPPORTED: integer = -6;
//   (   )
//  
        ERR_IO: integer = -100;
//      
				ERR_FORMAT: integer = -101;
//     
				ERR_TIMEOUT: integer = -102;
//        
				ERR_INVALID_CRC: integer = -103;
//  nErr
        ERR_NERR: integer = -104;
//  
				ERR_DEVERR: integer = -105;
				ERR_INVALID_ANSWER: integer = -106;

type


//  
TProcSetApiMode=function (n:DWORD):integer;stdcall;

// 
TProcOpenPort=function (n,speed,part,bits,stop,vid:DWORD):integer;stdcall;

//  
TProcSetupPort=function (n,speed,part,bits,stop,vid:DWORD):integer;stdcall;

//   
TProcSelectPort=function (n:DWORD):integer;stdcall;

//  
TProcClosePort=function :integer;stdcall;

//        / 
TProcOwenIO=function (adr,adr_type,is_read:DWORD;command,params:pchar;var param_sz:integer):integer;stdcall;

//     
TProcReadSInt=function (adr,adr_type:DWORD;command:pchar;var value:integer;index:integer):integer;stdcall;

//    
TProcReadUInt=function (adr_type,adr:DWORD;command:pchar;var value:DWORD;index:integer):integer;stdcall;
//       
TProcWriteByte=function (adr,adr_type:DWORD;command:pchar;value:integer;index:integer):integer;stdcall;
//       
TProcWriteWord=function (adr,adr_type:DWORD;command:pchar;value:integer;index:integer):integer;stdcall;


//        PIC
TProcWriteFloat24=function (adr,adr_type:DWORD;command:pchar;value:single;index:integer):integer;stdcall;
//        PIC
TProcReadFloat24=function (adr,adr_type:DWORD;command:pchar;var value:single;index:integer):integer;stdcall;


//         
TProcReadStoredDotS=function (adr,adr_type:DWORD;command:pchar; var val:single;index:integer):integer;stdcall;
//         
TProcWriteStoredDotS=function (adr,adr_type:DWORD;command:pchar;val:single;index:integer):integer;stdcall;
//         
TProcReadStoredDotU=function (adr,adr_type:DWORD;command:pchar; var val:single;index:integer):integer;stdcall;

//        IEEE32
TProcReadIEEE32=function (adr,adr_type:DWORD;command:pchar;var val:single;var tm:integer;index:integer):integer;stdcall;
//        IEEE32
TProcWriteIEEE32=function (adr,adr_type:DWORD;command:pchar;var val:single;index:integer):integer;stdcall;

//     PKP1   BCD
TProcReadPkpBCD=function (adr,adr_type:DWORD;command:pchar; var val:single):integer;stdcall;
//     PKP1
TProcWriteCSET=function (adr,adr_type:DWORD;prc:integer):integer;stdcall;
//     SI8
TProcReadDTMR=function (adr,adr_type:DWORD;var hrs:integer;var mins:integer;var sec:integer;var msec:integer):integer;stdcall;
//    8
TProcReadSI8BCD=function (adr,adr_type:DWORD;command:pchar; var val:integer):integer;stdcall;

//      
TProcLastErrToStr=procedure (res:pchar);stdcall;

//       AC2
TProcAC2_Open=function( n:DWORD):integer;stdcall;
TProcAC2_Close=function:integer;stdcall;
//  51
TProcAC2_ReadMpr51=function(ch,speed:DWORD;var t_prod:single;var t_suhogo:single;var t_vlag:single;var otn_vlag:single):integer;stdcall;
//  PiC
TProcAC2_ReadTRM__PiC=function(ch:DWORD; var Temperature:single;var Rele1:integer;var Rele2:integer;var Ust1:single;var Ust2:single;var Delta1:single;var Delta2:single):integer;stdcall;
TProcAC2_WriteTRM__PiC=function(ch:DWORD;ctrl_mask:integer;Rele1:integer;Rele2:integer;Ust1:single;Ust2:single;Delta1:single;Delta2:single):integer;stdcall;
// 38  38
TProcAC2_ReadTRM_UKT_38_T_and_U=function(ch:DWORD;var t1:single;var t2:single;var t3:single;var t4:single;var t5:single;var t6:single;var t7:single;var t8:single;var u1:single;var u2:single;var u3:single;var u4:single;var u5:single;var u6:single;var u7:single;var u8:single):integer;stdcall;
// 384   
TProcAC2_ReadUKT38sh4_IU=function(ch:DWORD;speed:DWORD; var t1:single;var t2:single;var t3:single;var t4:single;var t5:single;var t6:single;var t7:single;var t8:single;var u1:single;var u2:single;var u3:single;var u4:single;var u5:single;var u6:single;var u7:single;var u8:single;var d1:single;var d2:single;var d3:single;var d4:single;var d5:single;var d6:single;var d7:single;var d8:single):integer;stdcall;
// 384 
TProcAC2_ReadUKT38sh4_trp=function(ch:DWORD;speed:DWORD; var t1:single;var t2:single;var t3:single;var t4:single;var t5:single;var t6:single;var t7:single;var t8:single;var u1:single;var u2:single;var u3:single;var u4:single;var u5:single;var u6:single;var u7:single;var u8:single;var d1:single;var d2:single;var d3:single;var d4:single;var d5:single;var d6:single;var d7:single;var d8:single):integer;stdcall;
//384  
TProcAC2_ReadUKT38sh4_res=function(ch:DWORD;speed:DWORD; var t1:single;var t2:single;var t3:single;var t4:single;var t5:single;var t6:single;var t7:single;var t8:single;var u1:single;var u2:single;var u3:single;var u4:single;var u5:single;var u6:single;var u7:single;var u8:single;var d1:single;var d2:single;var d3:single;var d4:single;var d5:single;var d6:single;var d7:single;var d8:single):integer;stdcall;
// 32 -
TProcAC2_ReadTRM32=function(ch:DWORD;var Taero:single;var Tobr:single;var Tprjam:single;var Tgvs:single;var MustObr:single;var MustPrajm:single;var MustGvs:single;var WorkOnFwd:DWORD):integer;stdcall;
// 33 -
TProcAC2_ReadTRM33=function(ch:DWORD;var t1:single;var t2:single;var t3:single;var t4:single;var t5:single;var t6:single;var t7:single;var t8:single;var Rshift_TobrMax:single;var TavarMin:single;var TustAero:single;var TobrWaterLow:single):integer;stdcall;
// 34 -
TProcAC2_ReadTRM34=function(ch:DWORD;var t1:single;var t2:single;var t3:single;var t4:single;var U1_low:single;var U1_high:single;var U2_low:single;var U2_high:single ;var U3_low:single;var U3_high:single;var U4_low:single;var U4_high:single):integer;stdcall;


procedure display(s:string);overload;
var
        s2:string;
begin
        SetLength(s2,length(s));
        CharToOem(@s[1],@s2[1]);
        writeln(s2);
end;


procedure display(s:string;val:integer);overload;
var
        s2:string;
begin
        SetLength(s2,length(s));
        CharToOem(@s[1],@s2[1]);
        writeln(s2,val);
end;

procedure display(s:string;val:single);overload;
var
        s2:string;
begin
        SetLength(s2,length(s));
        CharToOem(@s[1],@s2[1]);
        writeln(s2,val:5:2);
end;


var

SetApiMode:TProcSetApiMode;

OpenPort:TProcOpenPort;
SelectPort:TProcSelectPort;
SetupPort:TProcSetupPort;
ClosePort:TProcClosePort;
OwenIO:TProcOwenIO;
ReadSInt:TProcReadSInt;

ReadUInt:TProcReadUInt;

WriteByte:TProcWriteByte;

WriteWord:TProcWriteWord;

WriteFloat24:TProcWriteFloat24;
ReadFloat24:TProcReadFloat24;

ReadStoredDotS:TProcReadStoredDotS;
WriteStoredDotS:TProcWriteStoredDotS;
ReadStoredDotU:TProcReadStoredDotU;

ReadIEEE32:TProcReadIEEE32;
WriteIEEE32:TProcWriteIEEE32;
ReadPkpBCD:TProcReadPkpBCD;
WriteCSET:TProcWriteCSET;
ReadDTMR:TProcReadDTMR;
ReadSI8BCD:TProcReadSI8BCD;

LastErrToStr:TProcLastErrToStr;

AC2_Open:TProcAC2_Open;
AC2_Close:TProcAC2_Close;
//  51
AC2_ReadMpr51:TProcAC2_ReadMpr51;
//  PiC
AC2_ReadTRM__PiC:TProcAC2_ReadTRM__PiC;
AC2_WriteTRM__PiC:TProcAC2_WriteTRM__PiC;
// 38  38
AC2_ReadTRM_UKT_38_T_and_U:TProcAC2_ReadTRM_UKT_38_T_and_U;
// 384   
AC2_ReadUKT38sh4_IU:TProcAC2_ReadUKT38sh4_IU;
// 384 
AC2_ReadUKT38sh4_trp:TProcAC2_ReadUKT38sh4_trp;
//384  
AC2_ReadUKT38sh4_res:TProcAC2_ReadUKT38sh4_res;
// 32 -
AC2_ReadTRM32:TProcAC2_ReadTRM32;
// 33 -
AC2_ReadTRM33:TProcAC2_ReadTRM33;
// 34 -
AC2_ReadTRM34:TProcAC2_ReadTRM34;


hLibInst:cardinal;

function InitLib:boolean;
begin
        hLibInst:=LoadLibrary('owen_io.dll');
        if(hLibInst=INVALID_HANDLE_VALUE) then begin result:=false;exit;end;

        SetApiMode:=GetProcAddress(hLibInst,'SetApiMode');
        if(not Assigned(SetApiMode)) then begin result:=false;exit;end;

        OpenPort:=GetProcAddress(hLibInst,'OpenPort');
        if(not Assigned(OpenPort)) then begin result:=false;exit;end;

        SelectPort:=GetProcAddress(hLibInst,'SelectPort');
        if(not Assigned(SelectPort)) then begin result:=false;exit;end;

        SetupPort:=GetProcAddress(hLibInst,'SetupPort');
        if(not Assigned(SetupPort)) then begin result:=false;exit;end;

        ClosePort:=GetProcAddress(hLibInst,'ClosePort');
        if(not Assigned(ClosePort)) then begin result:=false;exit;end;

        OwenIO:=GetProcAddress(hLibInst,'OwenIO');
        if(not Assigned(OwenIO)) then begin result:=false;exit;end;

        ReadSInt:=GetProcAddress(hLibInst,'ReadSInt');
        if(not Assigned(ReadSInt)) then begin result:=false;exit;end;

        ReadUInt:=GetProcAddress(hLibInst,'ReadUInt');
        if(not Assigned(ReadUInt)) then begin result:=false;exit;end;

        WriteByte:=GetProcAddress(hLibInst,'WriteByte');
        if(not Assigned(WriteByte)) then begin result:=false;exit;end;

        WriteWord:=GetProcAddress(hLibInst,'WriteWord');
        if(not Assigned(WriteWord)) then begin result:=false;exit;end;

        WriteFloat24:=GetProcAddress(hLibInst,'WriteFloat24');
        if(not Assigned(WriteFloat24)) then begin result:=false;exit;end;

        ReadFloat24:=GetProcAddress(hLibInst,'ReadFloat24');
        if(not Assigned(ReadFloat24)) then begin result:=false;exit;end;

        ReadStoredDotS:=GetProcAddress(hLibInst,'ReadStoredDotS');
        if(not Assigned(ReadStoredDotS)) then begin result:=false;exit;end;

        WriteStoredDotS:=GetProcAddress(hLibInst,'WriteStoredDotS');
        if(not Assigned(WriteStoredDotS)) then begin result:=false;exit;end;

        ReadStoredDotU:=GetProcAddress(hLibInst,'ReadStoredDotU');
        if(not Assigned(ReadStoredDotU)) then begin result:=false;exit;end;

        ReadIEEE32:=GetProcAddress(hLibInst,'ReadIEEE32');
        if(not Assigned(ReadIEEE32)) then begin result:=false;exit;end;

        WriteIEEE32:=GetProcAddress(hLibInst,'WriteIEEE32');
        if(not Assigned(WriteIEEE32)) then begin result:=false;exit;end;

        ReadPkpBCD:=GetProcAddress(hLibInst,'ReadPkpBCD');
        if(not Assigned(ReadPkpBCD)) then begin result:=false;exit;end;

        WriteCSET:=GetProcAddress(hLibInst,'WriteCSET');
        if(not Assigned(WriteCSET)) then begin result:=false;exit;end;

        ReadDTMR:=GetProcAddress(hLibInst,'ReadDTMR');
        if(not Assigned(ReadDTMR)) then begin result:=false;exit;end;

        ReadSI8BCD:=GetProcAddress(hLibInst,'ReadSI8BCD');
        if(not Assigned(ReadSI8BCD)) then begin result:=false;exit;end;

        LastErrToStr:=GetProcAddress(hLibInst,'LastErrToStr');
        if(not Assigned(LastErrToStr)) then begin result:=false;exit;end;

        AC2_Open:=GetProcAddress(hLibInst,'AC2_Open');
        if(not Assigned(AC2_Open)) then begin result:=false;exit;end;

        AC2_Close:=GetProcAddress(hLibInst,'AC2_Close');
        if(not Assigned(AC2_Close)) then begin result:=false;exit;end;
        //  51
        AC2_ReadMpr51:=GetProcAddress(hLibInst,'AC2_ReadMpr51');
        if(not Assigned(AC2_ReadMpr51)) then begin result:=false;exit;end;
        //  PiC
        AC2_ReadTRM__PiC:=GetProcAddress(hLibInst,'AC2_ReadTRM__PiC');
        if(not Assigned(AC2_ReadTRM__PiC)) then begin result:=false;exit;end;

        AC2_WriteTRM__PiC:=GetProcAddress(hLibInst,'AC2_WriteTRM__PiC');
        if(not Assigned(AC2_WriteTRM__PiC)) then begin result:=false;exit;end;

        // 38  38
        AC2_ReadTRM_UKT_38_T_and_U:=GetProcAddress(hLibInst,'AC2_ReadTRM_UKT_38_T_and_U');
        if(not Assigned(AC2_ReadTRM_UKT_38_T_and_U)) then begin result:=false;exit;end;
        // 384   
        AC2_ReadUKT38sh4_IU:=GetProcAddress(hLibInst,'AC2_ReadUKT38sh4_IU');
        if(not Assigned(AC2_ReadUKT38sh4_IU)) then begin result:=false;exit;end;
        // 384 
        AC2_ReadUKT38sh4_trp:=GetProcAddress(hLibInst,'AC2_ReadUKT38sh4_trp');
        if(not Assigned(AC2_ReadUKT38sh4_trp)) then begin result:=false;exit;end;

        //384  
        AC2_ReadUKT38sh4_res:=GetProcAddress(hLibInst,'AC2_ReadUKT38sh4_res');
        if(not Assigned(AC2_ReadUKT38sh4_res)) then begin result:=false;exit;end;
        // 32 -
        AC2_ReadTRM32:=GetProcAddress(hLibInst,'AC2_ReadTRM32');
        if(not Assigned(AC2_ReadTRM32)) then begin result:=false;exit;end;
        // 33 -
        AC2_ReadTRM33:=GetProcAddress(hLibInst,'AC2_ReadTRM33');
        if(not Assigned(AC2_ReadTRM33)) then begin result:=false;exit;end;
        // 34 -
        AC2_ReadTRM34:=GetProcAddress(hLibInst,'AC2_ReadTRM34');
        if(not Assigned(AC2_ReadTRM34)) then begin result:=false;exit;end;

        result:=true;


end;

procedure FreeLib;
begin
        FreeLibrary(hLibInst);
end;


var
        res:integer;
        params:array [0..7] of char;
        p_sz:integer;
        hr,m,s,ms,hh,tm,dcnt:integer;
        val:single;
        errStr:array [0..300] of char;
        err:string;
        type_d,type_i:integer;

        //2
        t_prod,t_suh,t_vlag,vlag:single;
        povtor:integer;
        r1,r2:integer;
        t,u1,u2,d1,d2:single;

        wr_msk,tk:dword;
        temper:array [0..7] of single;
        u:array [0..7] of single;
        d:array [0..7] of single;
        i:integer;
        work_mode:dword;

label ac3_work;
begin
        display('    owen_io  Delphi');
        if(not InitLib) then begin
                display('  ');
                exit;
        end;
        display('    AC2?(1-/0-)');
        readln(res);
        if res<>1  then goto ac3_work;
        //   COM1   AC2
        AC2_Open(COM_1);

        //    51
        res:=-1;
        povtor:=0;
        while((povtor<3) and (res=-1)) do
        begin
                inc(povtor);
                //      0  7
                res:=AC2_ReadMpr51(7,spd_9600,t_prod,t_suh,t_vlag,vlag);
        end;
        if(res>=0) then
        begin
                display('   51');
                display(' =',t_prod);
                display(' =',t_suh);
                display(' =',t_vlag);
                display(' =',vlag);
        end
        else
        begin
                display('    51');
                readln;
        end;
        //    5PiC

        povtor:=0;
        res:=-1;
        while((povtor<3) and (res<0)) do
        begin
                inc(povtor);
                //   1 ..      0  7
                res:=AC2_ReadTRM__PiC(5,t,r1,r2,u1,u2,d1,d2);
        end;

        if(res>=0) then
        begin
                display('   5PiC');
                if(t<>-300.0) then begin
                        display(' =',t);
                end
                else
                begin
                        display('   ');
                end;
                display(' 1=',r1);
                display(' 2=',r2);
                display(' 1=',u1);
                display(' 1=',d1);
                display(' 2=',u2);
                display(' 2=',d2);
        end
        else
        begin
                display('    5PiC');
                readln;
        end;

        tk:=GetTickCount(); //   

        display('   5PiC     10 ');

        wr_msk:=0; //    0  5 
                              //   R1  D1

        //      1   2
        //   
        wr_msk:=wr_msk or (1 shl 2); //U1;  r1  0;  r2  1;  ..
        wr_msk:=wr_msk or (1 shl 3); //U2;
        u1:=-10.3;
        u2:=-9.3;

        povtor:=0;
        res:=-1;
        while((povtor<3) and (res<0)) do
        begin
                inc(povtor);
                //   1 ..      0  7
                //        1   10
                //   
                //   ,     
                //  10    ...
                res:=AC2_WriteTRM__PiC(5,wr_msk,r1,r2,u1,u2,d1,d2);
        end;
        if(res>=0) then begin
                display(' ');
        end else
        begin
                display(' ');
        end;
        repeat
                povtor:=0;
                res:=-1;
                while((povtor<3) and (res<0)) do
                begin
                        inc(povtor);
                        //   1 ..      0  7
                        res:=AC2_ReadTRM__PiC(5,t,r1,r2,u1,u2,d1,d2);
                end;

                if(res>=0) then
                begin
                        display('------------------------------------');
                        display('   5PiC');
                        if(t<>-300.0) then
                        begin
                                display(' =',t);
                        end
                        else
                        begin
                                display('   ');
                        end;
                        display(' 1=',r1);
                        display(' 2=',r2);
                        display(' 1=',u1);
                        display(' 1=',d1);
                        display(' 2=',u2);
                        display(' 2=',d2);
                end
                else
                begin
                        display('    5PiC');
                        readln;
                end;
        until((tk+10000)<GetTickCount());

        display('  38');
        povtor:=0;
        res:=-1;
        while((povtor<3) and (res<0)) do
        begin
                inc(povtor);
                //   1  0
                res:=AC2_ReadTRM_UKT_38_T_and_U(1,temper[0],temper[1],temper[2],temper[3],temper[4],temper[5],temper[6],temper[7],u[0],u[1],u[2],u[3],u[4],u[5],u[6],u[7]);
        end;

        if(res>=0) then
        begin
                for i:=0 to 7 do
                begin
                        display('  :',i+1);
                        if(temper[i]<>-300) then
                                display(':',temper[i])
                        else
                                display('    ');
                        if(u[i]<>-300) then
                                display(':',u[i])
                        else
                                display('  ');
                end
        end
        else
        begin
                display('   38');
        end;

        display('  384   ');
        povtor:=0;
        res:=-1;
        while((povtor<3) and (res<0)) do
        begin
                //   1  0
                inc(povtor);
                res:=AC2_ReadUKT38sh4_trp(4,spd_9600,temper[0],temper[1],temper[2],temper[3],temper[4],temper[5],temper[6],temper[7],u[0],u[1],u[2],u[3],u[4],u[5],u[6],u[7],d[0],d[1],d[2],d[3],d[4],d[5],d[6],d[7]);
        end;

        if(res>=0) then
        begin
                for i:=0 to 7 do
                begin
                        display('  :',i+1);
                        if(temper[i]<>-300) then
                                display(': ',temper[i])
                        else
                                display('    ');
                        if(u[i]<>-300) then
                                display(':',u[i])
                        else
                                display('  ');
                        if(d[i]<>-300) then
                                display('Delta:',d[i])
                        else
                                display('  delta');
                end;
        end
        else
        begin
                display('   38');
        end;

        display('  32');
        povtor:=0;
        res:=-1;
        while((povtor<3) and (res<0)) do
        begin
                inc(povtor);
                //   4  2
                res:=AC2_ReadTRM32(3,temper[0],temper[1],temper[2],temper[3],temper[4],temper[5],temper[6],work_mode);
        end;
        if(res>=0) then
        begin
                display('   32');
                display('   :');
                if(temper[0]<>-300) then
                        display('',temper[0])
                else
                        display(' ');
                display('  ');
                if(temper[1]<>-300) then
                        display('',temper[1])
                else
                        display(' ');
                display('  ');
                if(temper[2]<>-300) then
                        display('',temper[2])
                else
                        display(' ');
                display(' ');
                if(temper[3]<>-300) then
                        display('',temper[3])
                else
                        display(' ');
                display('   ');
                if(temper[4]<>-300) then
                        display('',temper[4])
                else
                        display(' ');
                display('   ');
                if(temper[5]<>-300) then
                        display('',temper[5])
                else
                        display(' ');
                display('  ');
                if(temper[6]<>-300) then
                        display('',temper[6])
                else
                        display(' ');
                display(' ');
                if(work_mode=1) then
                        display('  ')
                else
                        display('  ');
                //(0000h -   , 0001h -  ).
        end
        else
        begin
                display('   32');
        end;

        display('  33');
        povtor:=0;
        res:=-1;
        while((povtor<3) and (res<0)) do
        begin
                inc(povtor);
                //   3  2
                res:=AC2_ReadTRM33(2,temper[0],temper[1],temper[2],temper[3],temper[4],temper[5],temper[6],temper[7],u[0],u[1],u[2],u[3]);
        end;
        if(res>=0) then
        begin
                display('   33');
                for i:=0 to 7 do
                begin
                        display('  :',i+1);
                        if(temper[i]<>-300) then
                                display(': ',temper[i])
                        else
                                display('    ');
                end;
                display('    .max  :');
                if(u[0]<>-300) then
                        display('>',u[0])
                else
                        display(' ');

                display('  .:');
                if(u[1]<>-300) then
                        display('>',u[1])
                else
                        display(' ');

                display('    .:');
                if(u[2]<>-300) then
                        display('>',u[2])
                else
                        display(' ');

                display('        :');
                if(u[3]<>-300) then
                        display('>',u[2])
                else
                        display(' ');
        end
        else
        begin
                display('   33');
        end;

        display('  34');
        povtor:=0;
        res:=-1;
        while((povtor<3) and (res<0)) do
        begin
                inc(povtor);
                //   3  2
                res:=AC2_ReadTRM34(2,temper[0],temper[1],temper[2],temper[3],u[0],u[1],u[2],u[3],u[4],u[5],u[6],u[7]);
        end;
        if(res>=0) then
        begin
                display('   34');
                for i:=0 to 3 do
                begin
                        display('  :',i+1);
                        if(temper[i]<>-300) then
                                display(': ',temper[i])
                        else
                                display('    ');
                        if(u[i*2]<>-300) then
                        begin
                                display(' 1 ',u[i*2]);
                        end
                        else
                        begin
                                display(' 1[] ');
                        end;
                        if(u[i*2+1]<>-300) then
                        begin
                                display(' 2',u[i*2+1]);
                        end
                        else
                        begin
                                display(' 2[]');
                        end;

                end

        end
        else
        begin
                display('   34');
        end;

        //      2
        AC2_Close();

//***************************************************************
ac3_work:;
        display('    AC3?(1-/0-)');
        readln(res);
        if res<>1  then exit;
        if(OpenPort(0,2,0,1,0,0)<0) then begin
                display('  ');
                exit;
        end;

        ReadFloat24(1,0,'Pv  ',val, 0);
        ReadFloat24(1,0,'SL-L',val, -1);
        display('  101  25');

        display('   LastErrToStr');
        display('   Pv  ...');

        res:=ReadFloat24(25,0,'Pv  ',val,-1);
        if(res>=0) then
        begin
                display('   ReadFloat24   101');
        end
        else
        begin
             LastErrToStr(errStr);
             display(' :');
             err:=errStr;
             display(err);
        end;

        display('   101');
        for hh:=0 to 10 do
        begin
              res:=ReadFloat24(25,0,'Pv  ',val,0);
              if(res>=0) then
              begin
                      display(' [1]=',val);
              end
              else begin
                      display(' !');
              end
        end;

        display(' Enter    ');readln;

        display('  8  32');

        display('  ');
        res:=ReadSI8BCD(32,0,'DCNT',dcnt);
        if(res>=0) then
        begin
                display(' DCNT=',dcnt);
        end
        else
        begin
                display('');
        end;
        display(' Enter    ');readln;
        display('  ...\n');

        for hh:=0 to 20 do
        begin
                res:=ReadDTMR(32,0,hr,m,s,ms);
                if(res>=0) then
                        writeln(hr:3,':',m:2,':',s:2,':',ms:3)
                else
                        display('');
                Sleep(200);
        end;

        display('   1');

        display('    50,0%...');
        res:=WriteCSET(24,0,500);
        if(res>=0) then
        begin
                display(' .');
        end
        else
        begin
                display(' ');
        end;
        for hh:=0 to 10 do
        begin
                res:=ReadPkpBCD(24,0,'DPRC',val);
                if(res>=0) then
                begin
                        write(' ',val:4:2,'% ');
                        if(val=50.0) then break;
                end
                else
                begin
                        display(' ');
                end;
                Sleep(500);
        end;

        display(' ');
        p_sz:=0;
        res:=OwenIO(24,0,0,'COPN',params,p_sz);
        if(res>=0) then
        begin

                display(' .');
        end
        else
        begin
                display(' ');
        end;

        for hh:=0 to 10 do
        begin
                res:=ReadPkpBCD(24,0,'DPRC',val);
                if(res>=0) then
                begin
                        write(' ',val:4:2,'% ');
                end
                else
                begin
                        display(' ');
                end;
                Sleep(500);
        end;
        display(' Enter    ');readln;

        display('  138  8 \n');

        for hh:=0 to 20 do
        begin
            res:=ReadIEEE32(8,0,'rEAd',val,tm,0);
            if(res>=0) then
            begin
                    writeln('Read=',val:6:3,' Time=',tm:5);
            end
            else begin
                    display(' !\n');
            end
        end;

        display(' Enter    ');readln;
        display('  8  16 ( 8) \n');

        for hh:=0 to 20 do
        begin
            res:=ReadIEEE32(16+7,0,'rEAd',val,tm,-1);
            if(res>=0) then
            begin
                    writeln('Read=',val:6:3,' Time=',tm:5);
            end
            else begin
                    display(' !\n');
            end
        end;

        display(' Enter    ');readln;

        display('  202 -  26  9600');

        display('   ...');
        //
        //
        //   1
        //
        //
        res:=ReadFloat24(26,0,'Pv  ',val,0);
        if(res>=0) then
        begin
                display(' [1]',val);
        end
        else begin
                display(' !');
        end;


        //
        //
        //   2
        //
        //
        res:=ReadFloat24(26,0,'Pv  ',val,1);
        if(res>=0) then
        begin
                display(' [2]=',val);
        end
        else begin
                display(' !');
        end;

        //
        //
        //  (SH  )  1
        //
        //
        res:=ReadFloat24(26,0,'SH  ',val,0);
        if(res>=0) then
        begin
                display(' [1]=',val);
        end
        else begin
                display(' !');
        end;

        //
        //
        //  (SH  )  1
        //
        //
        display('     (SH  )  1>');
        val:=2.2;
        readln(val);
        res:=WriteFloat24(26,0,'SH  ',val,0);
        if(res>=0) then
        begin
                display('  [1]=',val);
        end
        else begin
                display(' !');
        end;
        //
        //
        //  (SH  )  1
        //
        //
        res:=ReadFloat24(26,0,'SH  ',val,0);
        if(res>=0) then
        begin
                display(' [1]=',val);
        end
        else begin
                display(' !');
        end;

        //
        //
        //   (in.t )  1
        //
        //
        res:=ReadUInt(26,0,'dP  ',DWORD(type_d),0);
        if(res>=0) then
        begin
                display(' [1]=',type_d);
        end
        else begin
                display(' !');
        end;
        //
        //
        //   (in.t )  1
        //
        //

        display('   >');
        readln(type_d);
        res:=WriteByte(26,0,'dP  ',type_d,0);
        if(res>=0) then
        begin
                display('    [1]=',type_d);
        end
        else begin
                display(' !');
        end;
        ///
        //
        //   (in.t )  1
        //
        //
        res:=ReadUInt(26,0,'dP  ',dword(type_d),0);
        if(res>=0) then
        begin
                display(' [1]=',type_d);
        end
        else begin
                display(' !');
        end;

        display('   ...');

        //
        //
        //    
        //
        //
        res:=ReadUInt(26,0,'DiSP',dword(type_i),-1);
        if(res>=0) then
        begin
                display('  =',type_i);
        end
        else begin
                display(' !');
        end;

        display('   >');
        readln(type_i);
        res:=WriteByte(26,0,'DiSP',type_i,-1);
        if(res>=0) then
        begin
                display('   =',type_i);
        end
        else begin
                display(' !');
        end;

        res:=ReadUInt(26,0,'DiSP',dword(type_i),-1);
        if(res>=0) then
        begin
                display('  =',type_i);
        end
        else begin
                display(' !');
        end;

        display(' Enter   ');readln;

        ClosePort;
        FreeLib;

end.
